﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using PsgBase;
using PsgIntl;

namespace Categories
{
    [EditorClass, ViewGrid]
    public partial class Categories : Base
    {
        #region Members
        CategoriesBE.CategoriesDataTable table = new CategoriesBE.CategoriesDataTable();
        CategoriesBE.CategoriesRow rowA = null;
        #endregion

        #region Constructors

        public Categories()
        {
            InitializeComponent();
        }

        public Categories(ViewGrid _browser):base(_browser)
        {
            InitializeComponent();
        }
         
        public Categories(LookupGrid _search):base(_search)
        {
            InitializeComponent();
        }

        #endregion

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "categoryid";
            context.PsgFieldDisplay = "categoryname";
            context.PsgCommand = "categories";
            context.PsgServerTableName = "categories";
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddTable("categories", ID, "C");
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "CATEGORIES":
                    table = (CategoriesBE.CategoriesDataTable)SetMainData(dt, table);
                    rowA = (CategoriesBE.CategoriesRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edCategory, table.categorynameColumn);
            BindEdit(edDescription, table.descriptionColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.categorynameColumn, GetIntl(Intl.Category), 150);
            this.ColumnsView(table.descriptionColumn, GetIntl(Intl.Description), 250);

            this.FiltersView(table.categorynameColumn, GetIntl(Intl.Category));
            this.FiltersView(table.descriptionColumn, GetIntl(Intl.Description));
        }
    }
}
